Contributing
------------

Gherkin is an open source, community-driven project. If you'd like to contribute, feel free to do this, but remember to follow this few simple rules:

- Make your feature addition or bug fix,
- __Always__ as base for your changes use `develop` branch (all new development happens here, `master` branch is for releases & hotfixes only),
- Add tests for those changes (please look into `tests/` folder for some examples). This is important so we don't break it in a future version unintentionally,
- Commit your code, but do not mess with `CHANGES.md`,
- __Remember__: when you create Pull Request, always select `develop` branch as target, otherwise it will be closed.

Running tests
-------------

Make sure that you don't break anything with your changes by running:

```bash
$> phpunit
```

Contributing to Gherkin Translations
------------------------------------

Gherkin supports &rarr;40 different languages and you could add more! You might notice
`i18n.php` file in the root of the library. This file is downloaded and **autogenerated** 
from original [cucumber/gherkin translations](https://github.com/cucumber/gherkin/blob/master/lib/gherkin/i18n.yml).
So, in order to fix/update/add some translation, you should send Pull Request to the
`cucumber/gherkin` repository. `Behat\Gherkin` will redownload/regenerate translations
from there before each release.

It might sounds difficult, but this way of dictionary sharing gives you ability to
migrate your `*.feature` files from language to language and library to library without
the need to rewrite/modify them - same dictionary (Gherkin) used everywhere.
